<?php
/*
Plugin Name: De Web Developer: Classic widgets & editor
Description: Schakel de klassieke widgets en de klassieke editor in of uit via de instellingen.
Version: 2.1.1
Author: DWSD Groep
Author URI: https://repository.dwsdgroep.nl/
*/

// Voeg een instelling toe aan het WordPress-instellingenmenu
function dwsd_add_settings_page() {
    add_options_page(
        'De Web Developer: Classic widgets & editor',
        'Classic widgets & editor',
        'manage_options',
        'dwsd_classic_widgets_editor',
        'dwsd_settings_page'
    );
}
add_action( 'admin_menu', 'dwsd_add_settings_page' );

// Toon de instellingenpagina
function dwsd_settings_page() {
    ?>
    <div class="wrap">
        <h1>De Web Developer: Classic widgets & editor</h1>
        <style>
        /* Standaard voor button repository */
        .dwsd-widget-content { font-family: 'Roboto', sans-serif; }
        .dwsd-widget-counts { font-weight: 300; font-size: .75rem; }
        .dwsd-widget-rating { display: flex; justify-content: left; align-items: last baseline; font-size: 14px; margin: 5px 0; font-weight: 900; }
        .dwsd-widget-rating svg { width: 16px; height: 16px; fill: #F80; margin-left: 3px; }
        .dwsd-widget-container img { border-radius: 15px; }
        .dwsd-widget-container { padding: 24px; background: RGB(248, 170, 217, .17); border-radius: 15px; }
        .dwsd-widget-container:hover { background: RGBA(236, 0, 141, 0.15); }
        .dwsd-widget-title { font-weight: bold; font-size: 1.2rem; padding: 15px 0 0 0; }
        .dwsd-widget-subtitle { font-weight: 500; font-size: .79rem; padding: 0 0 7px 0; }
        .dwsd-widget-description { font-size: .96rem; padding: 7px 0 0 0; }
        .dwsd-widget-versie { color: #EC008D; font-size: .8rem; font-weight: 700; }
        .dwsd-widget-link-list .dwsd-widget-container { display: flex; max-width: 460px; margin-top: 20px; }
        .dwsd-widget-link-list .dwsd-widget-image { margin-right: 15px; }
        .dwsd-widget-link-list .dwsd-widget-image img { height: auto; min-width: 137px; margin-right: 10px; }
        .dwsd-widget-link-list .dwsd-widget-content { display: flex; flex-direction: column; justify-content: space-between; }
        .dwsd-widget-link-list .dwsd-widget-title { font-size: 18px; font-weight: bold; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-widget-subtitle { padding-bottom: 0; font-weight: 700; }
        .dwsd-widget-link-list .dwsd-widget-versie { font-size: 14px; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-widget-rating { display: flex; align-items: center; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-star-icon { width: 16px; height: 16px; margin-left: 5px; }
        .dwsd-widget-link-list .dwsd-widget-counts { margin-left: 5px; font-size: 14px; }
        .dwsd-widget-link-list .dwsd-widget-description { font-size: 14px; color: #555; margin-top: 0px; padding-top: 0; }
        .dwsd-star-icon { max-width: 14px; margin: 0 3px; }
        .dwsd-widget-link { text-decoration: none !important; color: inherit !important; }
        .dwsd-widget-link.dwsd-widget-link-list .dwsd-widget-title { padding: 0; }

        .dwsd-plugin-omschrijving { max-width: 500px; }
        .dwsd-widget-container { float: left; margin-bottom: 25px; }
        </style>

        <a class="dwsd-widget-link dwsd-widget-link-list" href="https://repository.dwsdgroep.nl/gratis-plugins/classic-widgets-en-editor/">
        <div class="dwsd-widget-container">
                <div class="dwsd-widget-image">
                    <img src="https://repository.dwsdgroep.nl/assets/images/plugins/classic-widgets4x4.svg" alt="classic widgets en editor">
                </div>
                <div class="dwsd-widget-content">
                    <div class="dwsd-widget-title">Classic widgets & editor</div>
        					<div class="dwsd-widget-subtitle">Door: De Web Developer</div>
        					<div class="dwsd-widget-versie">Versie: 2.1.1</div>
                    <div class="dwsd-widget-rating">
                        <span>4.8</span>
                        <img class="dwsd-star-icon" src="https://repository.dwsdgroep.nl/assets/images/star-solid.svg" />
                        <span class="dwsd-widget-counts">(2)</span>
                    </div>
                    <div class="dwsd-widget-description">Schakel de klassieke widgets en de klassieke editor ..</div>
                </div>
            </div>
        </a>
                <div id="dwsd-repository-wrapper">

            <a class="dwsd-widget-link dwsd-widget-link-list second" href="/wp-admin/admin.php?page=repository">
            <div class="dwsd-widget-container">
                    <div class="dwsd-widget-image">
                        <img src="https://repository.dwsdgroep.nl/assets/images/plugins/dwd-rep-logo4x4.svg" alt="dwd logo">
                    </div>
                    <div class="dwsd-widget-content">
                        <div class="dwsd-widget-title">Bekijk alle plugins</div>
                        <div class="dwsd-widget-description">Bekijk alle plugins en thema's van De Web Developer in de pluginrepository. Was een functie eerder onderdeel van het thema? Dan kun je deze nu als losse plugin downloaden en gebruiken.</div>
                    </div>
                </div>
            </a>

            </div>
        <div class="dwsd-plugin-omschrijving">
        <h2>Beschrijving</h2>
        <p>Met de De Web Developer: Classic widgets & editor plugin kun je eenvoudig de klassieke widgets en de klassieke editor in of uitschakelen op je WordPress-site. Deze plugin biedt een eenvoudige manier om de standaard block editor en block-based widgets uit te schakelen, zodat je kunt terugkeren naar de klassieke editor en widgets.</p>
      </div>
        <form method="post" action="options.php">
            <?php
            settings_fields( 'dwsd_settings_group' );
            do_settings_sections( 'dwsd_classic_widgets_editor' );
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Classic Widgets</th>
                    <td>
                        <label for="dwsd_classic_widgets">
                            <input type="checkbox" id="dwsd_classic_widgets" name="dwsd_classic_widgets" value="1" <?php checked( get_option( 'dwsd_classic_widgets' ), 1 ); ?> />
                            Schakel Classic Widgets in
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Classic Editor</th>
                    <td>
                        <label for="dwsd_classic_editor">
                            <input type="checkbox" id="dwsd_classic_editor" name="dwsd_classic_editor" value="1" <?php checked( get_option( 'dwsd_classic_editor' ), 1 ); ?> />
                            Schakel Classic Editor in
                        </label>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Registreer de instellingen
function dwsd_register_settings() {
    register_setting( 'dwsd_settings_group', 'dwsd_classic_widgets' );
    register_setting( 'dwsd_settings_group', 'dwsd_classic_editor' );
}
add_action( 'admin_init', 'dwsd_register_settings' );

// Pas de filters aan op basis van de instellingen
function dwsd_apply_settings() {
    if ( get_option( 'dwsd_classic_widgets' ) ) {
        add_filter( 'use_widgets_block_editor', '__return_false' );
    }

    if ( get_option( 'dwsd_classic_editor' ) ) {
        add_filter( 'use_block_editor_for_post', '__return_false' );
    }
}
add_action( 'init', 'dwsd_apply_settings' );
// === Instellingen-link toevoegen op de plugins-pagina
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $settings_link = '<a href="/wp-admin/options-general.php?page=dwsd_classic_widgets_editor">Instellingen</a>';
    array_unshift($links, $settings_link);
    return $links;
});
