<?php

// Status
add_action( 'wp_dashboard_setup', 'seo_dashboard_add_widgets' );
function seo_dashboard_add_widgets() {
	wp_add_dashboard_widget( 'dd_dashboard_widget_news', __( '<img src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg"> De Web Developer Status', 'dd' ), 'dd_dashboard_widget_news_handler' );
}

function dd_dashboard_widget_news_handler() {
	_e( '
  <style>/*{;} SUPPORT TEGOEDEN -- */
  #dd_dashboard_widget_news .hndle.ui-sortable-handle { max-width: 188px !important; }</style>
  <iframe class="dwd-notificaties" src="https://dwd.es/notificaties/notificaties-wordpress.php" style="border:0px #ffffff none;" name="myiFrame" scrolling="yes"
  frameborder="1" marginheight="0px" marginwidth="0px" height="550px" width="100%" allowfullscreen></iframe>

	', 'dd' );
}


/* Koppel style van Storefront aan dit sub thema*/
function childtheme_parent_styles() {

// Style inladen
 wp_enqueue_style( 'parent', get_template_directory_uri().'/style.css' );
}
add_action( 'wp_enqueue_scripts', 'childtheme_parent_styles');

// ++ Intergratie van DWD wp-admin thema in versie 1.4
function admin_style() {
  wp_enqueue_style('admin-styles', get_stylesheet_directory_uri() . '/wp-admin/wp-admin.css');
}
add_action('admin_enqueue_scripts', 'admin_style');

function my_login_stylesheet() {
  wp_enqueue_style( 'custom-login', get_stylesheet_directory_uri() . '/wp-admin/wp-admin.css' );
}
add_action( 'login_enqueue_scripts', 'my_login_stylesheet' );

function favicon4admin() {
  echo '<link rel="Shortcut Icon" type="image/x-icon" href="' . get_bloginfo('wpurl') . '/wp-content/themes/dewebdeveloper/wp-admin/images/favicon.ico" />';
}
add_action( 'admin_head', 'favicon4admin' );

//* Make Font Awesome available
add_action( 'wp_enqueue_scripts', 'enqueue_font_awesome' );
function enqueue_font_awesome() {

	wp_enqueue_style( 'font-awesome', '//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css' );

}

// ++ Dashboard knop (Topbar)
function custom_button_example($wp_admin_bar){
  $args = array(
    'id' => 'custom-button',
    'title' => '<img src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg"> <script src="//code.tidio.co/sb4sxgsslwdf4dfikklvsz4lpitkrbdh.js" async></script>',
    'href' => '/wp-admin/admin.php?page=page%3Ddistributie',
    'meta' => array(
      'class' => 'custom-button-class'
    )
  );
  $wp_admin_bar->add_node($args);
}

add_action('admin_bar_menu', 'custom_button_example', 50);

// ++ Distributie pagina (Linker menu)
function my_admin_menu() {
  add_menu_page(
    __( '<img src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg"> Distributie', 'my-textdomain' ),
    __( '<img src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg"> Distributie', 'my-textdomain' ),
    'manage_options',
    'page=distributie',
    'my_admin_page_contents',
    'dashicons-schedule',
    3
  );
}

add_action( 'admin_menu', 'my_admin_menu' );

function my_admin_page_contents() {
  ?>
  <html>
  <div class="distributie-pagina">
    <iframe src="/wp-content/themes/dewebdeveloper/distributie/" style="border:0px #ffffff none;" name="myiFrame" scrolling="yes"
    frameborder="1" marginheight="0px" marginwidth="0px" height="820px" width="100%" allowfullscreen></iframe>
    </html>
  </div>
  <?php
}

// Classic widgets terug zetten
add_filter( 'use_widgets_block_editor', '__return_false' );

// Classic pagina post terug zetten
add_filter( 'use_block_editor_for_post', '__return_false' );

// SVG als veilig markeren in WordPress
function add_file_types_to_uploads($file_types){
$new_filetypes = array();
$new_filetypes['svg'] = 'image/svg+xml';
$file_types = array_merge($file_types, $new_filetypes );
return $file_types;
}
add_filter('upload_mimes', 'add_file_types_to_uploads');

// Toevoeging van custom menu aan thema
function wpb_custom_new_menu() {
  register_nav_menu('my-custom-menu',__( 'My Custom Menu' ));
}
add_action( 'init', 'wpb_custom_new_menu' );

// Toevoeging van FontAwesome aan thema
add_action( 'wp_enqueue_scripts', 'enqueue_load_fa' );
function enqueue_load_fa() {
wp_enqueue_style( 'load-fa', '/wp-content/themes/dewebdeveloper/fontawesome-v6/css/all.css' );
}

// Shortcodes aanmaken
include('shortcodes/shortcode-library.php');

// Menu rechts uitlijnen
add_action( 'wp_loaded', 'align_menu_right');

function align_menu_right() {
    remove_action( 'storefront_header', 'storefront_secondary_navigation', 30 );
    remove_action( 'storefront_header', 'storefront_primary_navigation', 50 );
    add_action( 'storefront_header', 'storefront_primary_navigation', 30 );

    if ( function_exists( 'storefront_header_cart' ) ) {
        remove_action( 'storefront_header', 'storefront_header_cart', 60 );
    }
    remove_action( 'storefront_header', 'storefront_product_search', 40 );
}


/**
*Verbergen van verzendmethode indien gratis verzending*
 */

function hide_shipping_when_free_is_available( $rates, $package ) {
	$new_rates = array();
	foreach ( $rates as $rate_id => $rate ) {
		// Only modify rates if free_shipping is present.
		if ( 'free_shipping' === $rate->method_id ) {
			$new_rates[ $rate_id ] = $rate;
			break;
		}
	}

	if ( ! empty( $new_rates ) ) {
		//Save local pickup if it's present.
		foreach ( $rates as $rate_id => $rate ) {
			if ('local_pickup' === $rate->method_id ) {
				$new_rates[ $rate_id ] = $rate;
				break;
			}
		}
		return $new_rates;
	}

	return $rates;
}

add_filter( 'woocommerce_package_rates', 'hide_shipping_when_free_is_available', 10, 2 );



// Geautomatiseerde footer thema
function storefront_credit() {
    ?>
    <div class="site-info">
        © <?php  echo date("Y");?> <?php echo get_bloginfo( 'name' ); ?>.
        Alle rechten voorbehouden. Ontwikkeling door <a href="https://www.dewebdeveloper.nl" target="_blank" title="De Web Developer - Amsterdam" rel="author">
        De Web Developer <img src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg" alt="Webdesign en webdevelopment Amsterdam"></a>
    </div><!-- .site-info -->
    <?php
}
