<?php
/*
Plugin Name: De Web Developer: Onderhoudsmodus
Description: Vergrendelt de frontend voor niet-ingelogde gebruikers. Ingelogde gebruikers kunnen de frontend bekijken door in te loggen via het dashboard. Na het inloggen zal deze sessie worden opgeslagen middels een cookie.
Version: 1.0
Author: De Web Developer
Author URI: http://www.dewebdeveloper.nl/
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Functie om de CSS van de plugin toe te voegen aan het wp-admin gedeelte
function dwd_om_enqueue_admin_styles() {
    // Voeg de CSS-bestand van de plugin toe voor het wp-admin gedeelte
    wp_enqueue_style('dwd-om-admin-styles', plugin_dir_url(__FILE__) . '/styles/onderhoudsmodus-admin.css', array(), '1.0', 'all');
}

// Voeg de actie toe om de CSS toe te voegen aan het wp-admin gedeelte
add_action('admin_enqueue_scripts', 'dwd_om_enqueue_admin_styles');


// Vergrendel de frontend voor niet-ingelogde gebruikers
add_action('template_redirect', 'dwd_om_protect_frontend');
function dwd_om_protect_frontend() {
    if (!is_user_logged_in() && !is_admin()) {
        $maintenance_url = site_url('/onderhoud/');
        wp_safe_redirect($maintenance_url);
        exit;
    }
}

// Voeg onderhoudsbestanden toe bij activeren van de plugin
register_activation_hook(__FILE__, 'dwd_om_add_maintenance_files');
function dwd_om_add_maintenance_files() {
    $plugin_dir = plugin_dir_path(__FILE__);
    $maintenance_dir = ABSPATH . '/onderhoud';
    if (!is_dir($maintenance_dir)) {
        mkdir($maintenance_dir, 0755, true);
    }

    // Kopieer de inhoud van de onderhoudsmap naar de doelmap
    dwd_om_copy_files_recursive($plugin_dir . 'onderhoud/', $maintenance_dir);

    // Verwijder de onderhoudsmap uit de pluginmap
    $plugin_maintenance_dir = $plugin_dir . 'onderhoud';
    if (is_dir($plugin_maintenance_dir)) {
        dwd_om_rrmdir($plugin_maintenance_dir);
    }
}

// Recursieve functie om bestanden en mappen te kopiëren
function dwd_om_copy_files_recursive($source, $destination) {
    if (!is_dir($source)) {
        return false;
    }

    if (!is_dir($destination)) {
        mkdir($destination, 0755, true);
    }

    $files = scandir($source);
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            if (is_dir($source . '/' . $file)) {
                dwd_om_copy_files_recursive($source . '/' . $file, $destination . '/' . $file);
            } else {
                copy($source . '/' . $file, $destination . '/' . $file);
            }
        }
    }

    return true;
}

// Recursieve functie om map te verwijderen
function dwd_om_rrmdir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (filetype($dir . "/" . $object) == "dir") {
                    dwd_om_rrmdir($dir . "/" . $object);
                } else {
                    unlink($dir . "/" . $object);
                }
            }
        }
        reset($objects);
        rmdir($dir);
    }
}

// Voeg een link toe om de plugin uit te schakelen via de topbar

add_action('admin_bar_menu', 'dwd_om_add_disable_link_to_topbar', 999);
function dwd_om_add_disable_link_to_topbar($wp_admin_bar) {
    if (is_admin() && current_user_can('activate_plugins')) {
        $wp_admin_bar->add_menu(array(
            'id' => 'disable-plugin-link',
            'title' => '<img class="plg-logo" src="/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg"/> Schakel <b>"Onderhoudsmodus"</b> uit',
            'href' => wp_nonce_url(admin_url('plugins.php?action=deactivate&plugin=' . plugin_basename(__FILE__)), 'deactivate-plugin_' . plugin_basename(__FILE__))
        ));
    }
}

// Voeg details tab toe
add_filter('plugin_row_meta', 'dwd_om_add_details_tab', 10, 2);
function dwd_om_add_details_tab($links, $file) {
    if ($file == plugin_basename(__FILE__)) {
        $details_link = '<a href="http://www.dewebdeveloper.nl/" target="_blank">Details</a>';
        array_push($links, $details_link);
    }
    return $links;
}

?>
