<?php
/*
Plugin Name: De Web Developer: Recent Posts Thumbnails
Description: Voeg onbeperkt featured shortcodes toe via de admin (met titel, categorie en limiet).
Version: 1.1.0
Author: DWSD Groep Amsterdam
Author URI: https://dwsdgroep.nl/
Plugin URI: https://repository.dwsdgroep.nl/
*/

if (!defined('ABSPATH')) exit;

// === Register settings
function dwsd_register_featured_settings() {
    register_setting('dwsd_featured_options_group', 'dwsd_featured_shortcodes');
}
add_action('admin_init', 'dwsd_register_featured_settings');

// === Admin page
function dwsd_featured_shortcode_page() {
    $shortcodes = get_option('dwsd_featured_shortcodes', []);
    ?>
    <div class="wrap">
            <div class="wrap">
        <h1>De Web Developer: Recent Posts Thumbnails</h1>
        <style>
        /* Standaard voor button repository */
        .dwsd-widget-content { font-family: 'Roboto', sans-serif; }
        .dwsd-widget-counts { font-weight: 300; font-size: .75rem; }
        .dwsd-widget-rating { display: flex; justify-content: left; align-items: last baseline; font-size: 14px; margin: 5px 0; font-weight: 900; }
        .dwsd-widget-rating svg { width: 16px; height: 16px; fill: #F80; margin-left: 3px; }
        .dwsd-widget-container img { border-radius: 15px; }
        .dwsd-widget-container { padding: 24px; background: RGB(248, 170, 217, .17); border-radius: 15px; }
        .dwsd-widget-container:hover { background: RGBA(236, 0, 141, 0.15); }
        .dwsd-widget-title { font-weight: bold; font-size: 1.2rem; padding: 15px 0 0 0; }
        .dwsd-widget-subtitle { font-weight: 500; font-size: .79rem; padding: 0 0 7px 0; }
        .dwsd-widget-description { font-size: .96rem; padding: 7px 0 0 0; }
        .dwsd-widget-versie { color: #EC008D; font-size: .8rem; font-weight: 700; }
        .dwsd-widget-link-list .dwsd-widget-container { display: flex; max-width: 460px; margin-top: 20px; }
        .dwsd-widget-link-list .dwsd-widget-image { margin-right: 15px; }
        .dwsd-widget-link-list .dwsd-widget-image img { height: auto; min-width: 137px; margin-right: 10px; }
        .dwsd-widget-link-list .dwsd-widget-content { display: flex; flex-direction: column; justify-content: space-between; }
        .dwsd-widget-link-list .dwsd-widget-title { font-size: 18px; font-weight: bold; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-widget-subtitle { padding-bottom: 0; font-weight: 700; }
        .dwsd-widget-link-list .dwsd-widget-versie { font-size: 14px; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-widget-rating { display: flex; align-items: center; margin-bottom: 5px; }
        .dwsd-widget-link-list .dwsd-star-icon { width: 16px; height: 16px; margin-left: 5px; }
        .dwsd-widget-link-list .dwsd-widget-counts { margin-left: 5px; font-size: 14px; }
        .dwsd-widget-link-list .dwsd-widget-description { font-size: 14px; color: #555; margin-top: 0px; padding-top: 0; }
        .dwsd-star-icon { max-width: 14px; margin: 0 3px; }
        .dwsd-widget-link { text-decoration: none !important; color: inherit !important; }
        .dwsd-widget-link.dwsd-widget-link-list .dwsd-widget-title { padding: 0; }

        .dwsd-plugin-omschrijving { max-width: 500px; }
        .dwsd-widget-container { float: left; margin-bottom: 25px; }
        th { color: #000 !important; }
        </style>

        <a class="dwsd-widget-link dwsd-widget-link-list" href="https://repository.dwsdgroep.nl/">
        <div class="dwsd-widget-container">
                <div class="dwsd-widget-image">
                    <img src="https://repository.dwsdgroep.nl/assets/images/plugins/classic-widgets4x4.svg" alt="classic widgets en editor">
                </div>
                <div class="dwsd-widget-content">
                    <div class="dwsd-widget-title">Recent Post Thumbnails</div>
        					<div class="dwsd-widget-subtitle">Door: De Web Developer</div>
        					<div class="dwsd-widget-versie">Versie: 1.1.0</div>
                    <div class="dwsd-widget-rating">
                        <span>4.8</span>
                        <img class="dwsd-star-icon" src="https://repository.dwsdgroep.nl/assets/images/star-solid.svg" />
                        <span class="dwsd-widget-counts">(1)</span>
                    </div>
                    <div class="dwsd-widget-description">Maak shortcodes van relevante categorieen van je posts ..</div>
                </div>
            </div>
        </a>

        <div id="dwsd-repository-wrapper">

            <a class="dwsd-widget-link dwsd-widget-link-list second" href="/wp-admin/admin.php?page=repository">
            <div class="dwsd-widget-container">
                    <div class="dwsd-widget-image">
                        <img src="https://repository.dwsdgroep.nl/assets/images/plugins/dwd-rep-logo4x4.svg" alt="dwd logo">
                    </div>
                    <div class="dwsd-widget-content">
                        <div class="dwsd-widget-title">Bekijk alle plugins</div>
                        <div class="dwsd-widget-description">Bekijk alle plugins en thema's van De Web Developer in de pluginrepository. Was een functie eerder onderdeel van het thema? Dan kun je deze nu als losse plugin downloaden en gebruiken.</div>
                    </div>
                </div>
            </a>

            </div>

        <div class="dwsd-plugin-omschrijving">
        <h2>Beschrijving</h2>
        <p>Dit script voegt een aangepaste instellingenpagina toe aan het WordPress beheerdersgedeelte, waarin beheerders dynamisch shortcodes kunnen aanmaken om recente blogberichten te tonen. De gebruiker kan in een tabel meerdere shortcodes configureren door velden in te vullen zoals de naam van de shortcode, de categorie waaruit berichten moeten worden getoond, een optionele titel, en het maximale aantal berichten dat weergegeven moet worden. Met behulp van JavaScript kunnen eenvoudig nieuwe rijen worden toegevoegd of verwijderd zonder dat de pagina herladen hoeft te worden.</p>
        <h2>Gebruik van shortcodes</h2>
        <p>Een voorbeeld van een shortcode is:</p>
        <pre><code>[dwsd_featured_test]</code></pre>
        <p>Vervang <code>test</code> door de naam (slug) die je zelf hebt opgegeven bij het aanmaken van de shortcode. <b>Let op!</b> graag invoeren zonder hoofdletters! Zo toon je de juiste inhoud op de gewenste plek.</p>

      </div>
        <form method="post" action="options.php">
            <?php settings_fields('dwsd_featured_options_group'); ?>
            <table id="featured-shortcodes-table" class="form-table">
                <tr>
                    <th>Naam (slug)</th>
                    <th>Categorie-slug</th>
                    <th>Titel boven de lijst</th>
                    <th>Aantal</th>
                    <th>Verwijder</th>
                </tr>
                <?php if (!empty($shortcodes)) : foreach ($shortcodes as $index => $sc) : ?>
                    <tr>
                        <td><input type="text" name="dwsd_featured_shortcodes[<?php echo $index; ?>][name]" value="<?php echo esc_attr($sc['name']); ?>" required></td>
                        <td><input type="text" name="dwsd_featured_shortcodes[<?php echo $index; ?>][category]" value="<?php echo esc_attr($sc['category']); ?>"></td>
                        <td><input type="text" name="dwsd_featured_shortcodes[<?php echo $index; ?>][title]" value="<?php echo esc_attr($sc['title']); ?>"></td>
                        <td><input type="number" name="dwsd_featured_shortcodes[<?php echo $index; ?>][limit]" value="<?php echo esc_attr($sc['limit']); ?>" min="1"></td>
                        <td><button type="button" class="remove-row button">×</button></td>
                    </tr>
                <?php endforeach; endif; ?>
            </table>
            <p><button type="button" class="button" id="add-featured-row">+ Nieuwe shortcode toevoegen</button></p>
            <?php submit_button(); ?>
        </form>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const table = document.getElementById("featured-shortcodes-table");

            document.getElementById("add-featured-row").addEventListener("click", function () {
                const index = table.rows.length - 1;
                const newRow = document.createElement("tr");
                newRow.innerHTML = `
                    <td><input type="text" name="dwsd_featured_shortcodes[${index}][name]" required></td>
                    <td><input type="text" name="dwsd_featured_shortcodes[${index}][category]"></td>
                    <td><input type="text" name="dwsd_featured_shortcodes[${index}][title]"></td>
                    <td><input type="number" name="dwsd_featured_shortcodes[${index}][limit]" value="3" min="1"></td>
                    <td><button type="button" class="remove-row button">×</button></td>
                `;
                table.appendChild(newRow);
            });

            document.addEventListener("click", function (e) {
                if (e.target.classList.contains("remove-row")) {
                    e.target.closest("tr").remove();
                }
            });
        });
    </script>
    <?php
}
add_action('admin_menu', function () {
    add_options_page('Recent Post Tumbnail', 'Recent Post Tumbnail', 'manage_options', 'dwsd-featured', 'dwsd_featured_shortcode_page');
});

// === Dynamisch shortcodes registreren
add_action('init', function () {
    $shortcodes = get_option('dwsd_featured_shortcodes', []);
    if (!empty($shortcodes)) {
        foreach ($shortcodes as $sc) {
            if (!empty($sc['name'])) {
                $name = sanitize_title($sc['name']);
                add_shortcode('dwsd_featured_' . $name, function () use ($sc) {
                    return dwsd_featured_shortcode_render($sc);
                });
            }
        }
    }
});

// === Render functie
function dwsd_featured_shortcode_render($sc) {
    $category_slug = $sc['category'] ?? '';
    $limit = intval($sc['limit'] ?? 3);
    $title = esc_html($sc['title'] ?? '');

    $args = [
        'post_type' => 'post',
        'posts_per_page' => $limit,
        'post_status' => 'publish',
        'ignore_sticky_posts' => true,
        'orderby' => 'date',
        'order' => 'DESC',
    ];

    if (!empty($category_slug)) {
        $term = get_term_by('slug', $category_slug, 'category');
        if ($term) {
            $args['category__in'] = [$term->term_id];
        }
    }

    $query = new WP_Query($args);

    ob_start(); ?>
    <style>
        .dwsd-shortcode-posts {
            opacity: 0;
            transition: opacity 1s ease;
        }
        .dwsd-shortcode-posts.visible {
            opacity: 1;
        }
        ul.dwsd-post-list {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            list-style: none;
            padding: 0;
            /* max-width en margin: 0 auto verwijderd */
        }
        .dwsd-post-list a {
            text-align: left !important;
            font-size: 1.5rem;
            text-decoration: none !important;
            color: #333 !important;
        }
        .dwsd-post-list .attachment-medium.size-medium.wp-post-image {
            margin-bottom: 25px !important;
        }
        ul.dwsd-post-list li {
            max-width: 100%;
            overflow: hidden;
        }
        ul.dwsd-post-list li.hidden {
            display: none;
        }
        .dwsd-load-more {
            display: block;
            margin: 30px 0;
            margin-bottom: 0px;
            padding: 10px 20px;
            border: none;
            cursor: pointer;
            border-radius: 20px !important;
            font-weight: unset;
            margin-bottom: 85px;
            background-color: var(--dwsd--color--dark-cyan);
            font-family: 'NAP Regular', sans-serif;
            color: #FFF;
            font-size: 1.14rem;
        }
    </style>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        setTimeout(function () {
            const els = document.querySelectorAll('.dwsd-shortcode-posts');
            els.forEach(el => el.classList.add('visible'));
        }, 1000);

        const container = document.querySelector('.dwsd-shortcode-posts');
        if (!container) return;

        const posts = container.querySelectorAll('ul.dwsd-post-list li');
        let visibleCount = 4;

        posts.forEach((post, i) => {
            if (i >= visibleCount) post.classList.add('hidden');
        });

        const loadMoreBtn = container.querySelector('.dwsd-load-more');
        if (!loadMoreBtn) return;

        loadMoreBtn.addEventListener('click', function () {
            let newVisibleCount = visibleCount + 4;
            posts.forEach((post, i) => {
                if (i < newVisibleCount) post.classList.remove('hidden');
            });
            visibleCount = newVisibleCount;

            if (visibleCount >= posts.length) {
                loadMoreBtn.style.display = 'none';
            }
        });
    });
    </script>
    <div class="dwsd-shortcode-posts" style="margin-top:30px;">
        <?php if ($title): ?>
            <h2><?php echo $title; ?></h2>
        <?php endif; ?>
        <ul class="dwsd-post-list">
            <?php
            $count = 0;
            while ($query->have_posts()) : $query->the_post();
                $count++;
            ?>
                <li class="<?php echo ($count > 4) ? 'hidden' : ''; ?>">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" style="text-align:center; display:block;">
                        <?php
                        if (has_post_thumbnail()) {
                            the_post_thumbnail('medium_large', ['style' => 'display:block; margin:0 auto 5px; max-height:200px; object-fit:cover;']);
                        } else {
                            echo '<img src="' . esc_url(content_url('uploads/2025/03/placeholder.svg')) . '" alt="' . esc_attr(get_the_title()) . '" style="display:block; margin:0 auto 5px; max-height:200px;">';
                        }
                        ?>
                        <span><?php the_title(); ?></span>
                    </a>
                </li>
            <?php endwhile; wp_reset_postdata(); ?>
        </ul>

        <?php if ($count > 4): ?>
            <button class="dwsd-load-more">Laad meer</button>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}
// === Instellingen-link toevoegen op de plugins-pagina
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $settings_link = '<a href="options-general.php?page=dwsd-featured">Instellingen</a>';
    array_unshift($links, $settings_link);
    return $links;
});
