<?php
/*
Plugin Name: De Web Developer: Shortcodes
Description: Een eenvoudige plugin om shortcodes op basis van HTML-invoer te beheren.
Version: 1.2
Author: DWSD Groep Amsterdam
Author URI: https://www.dwsdgroep.nl
*/

if (!defined('ABSPATH')) {
    exit;
}

add_action('admin_menu', 'dwsd_shortcode_manager_menu');

function dwsd_shortcode_manager_menu() {
    add_menu_page(
        'Shortcodes',
        'Shortcodes',
        'manage_options',
        'dwsd-shortcode-manager',
        'dwsd_shortcode_manager_page',
        plugins_url('assets/favicon-small-logo-2024.svg', __FILE__),
               4 // Prioriteit
           );
}

function my_plugin_admin_styles() {
    wp_enqueue_style(
        'my-plugin-admin-style', // Unieke handle (naam)
        plugin_dir_url(__FILE__) . 'assets/css/dwsd-style.css', // Pad naar je CSS bestand
        array(), // Geen afhankelijkheden
        '1.0', // Versie
        'all' // Media type (optioneel)
    );
}
add_action('admin_enqueue_scripts', 'my_plugin_admin_styles');



function dwsd_shortcode_manager_page() {
    $shortcodes = get_option('dwsd_shortcodes', []);
    ?>
    <div class="wrap-shorts">

      <h1>De Web Developer: Shortcodes</h1>
      <div class="wrapper-smarter-inner-content-right-popup">
        <?php
        // URL van de externe repository pagina
        $url = 'https://repository.dwsdgroep.nl/dwsd-repository.php';

        // Haal de inhoud op via wp_remote_get
        $response = wp_remote_get($url);

        // Controleer of er geen fout is bij het ophalen van de inhoud
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            echo '<p>Er is een fout opgetreden: ' . esc_html($error_message) . '</p>';
        } else {
            // Verkrijg de HTML inhoud van de externe pagina
            $body = wp_remote_retrieve_body($response);

            // Toon de inhoud
            echo $body;
        }
        ?>
      </div>

              <p class="dwd-function-info">Welkom bij de instellingen voor de Web Shorts-functionaliteit!
Op deze pagina kun je shortcodes aanmaken en beheren. Deze shortcodes kun je eenvoudig gebruiken op verschillende locaties, zoals blogposts of reguliere pagina's. Het voordeel hiervan is dat dezelfde content automatisch wordt weergegeven op iedere pagina of post waar de shortcode is geplaatst. Je kunt daarnaast ook eenvoudig nieuwe shortcodes toevoegen.</p>
        <div id="shortcode-container">
            <?php foreach ($shortcodes as $index => $data): ?>
                <div class="shortcode-item">
                  <div class="label">Shortcode naam</div>
                    <input type="text" class="shortcode-name" value="<?php echo esc_attr($data['name']); ?>" placeholder="Shortcode naam..." />
                    <textarea class="html-input" placeholder="Voer hier je HTML in..."><?php echo esc_html($data['html']); ?></textarea>
                    <p>Gebruik shortcode: <span class="shortcode">[<?php echo esc_attr($data['name']); ?>]</span></p>
                    <button class="remove-shortcode">Verwijderen</button>
                </div>
            <?php endforeach; ?>
        </div>
        <h2 class="dwsd-end-title">Je bent klaar! Vergeet niet op te slaan.</h2>
        <p class="dwsd-end-paragraaf">Heb je problemen met het plaatsen van shortcodes of wil je meer weten over het toevoegen van HTML-elementen? Laat het ons weten! Stuur een e-mail naar <a href="mailto:info@dewebdeveloper.nl">info@dewebdeveloper.nl</a> of bel ons op 020 - 308 69 89</p>
        <button id="add-shortcode">Voeg Shortcode Toe</button>
        <button id="save-shortcodes">Sla Shortcodes Op</button>
    </div>

    <script>
        document.getElementById('add-shortcode').addEventListener('click', function() {
            const container = document.getElementById('shortcode-container');
            const newItem = document.createElement('div');
            newItem.className = 'shortcode-item';
            newItem.innerHTML = `
                <input type="text" class="shortcode-name" placeholder="Shortcode naam..." />
                <textarea class="html-input" placeholder="Voer hier je HTML in..."></textarea>
                <p>Gebruik shortcode: <span class="shortcode">[naam]</span></p>
                <button class="remove-shortcode">Verwijderen</button>
            `;
            container.appendChild(newItem);
        });

        document.getElementById('shortcode-container').addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-shortcode')) {
                e.target.parentElement.remove();
            }
        });

        document.getElementById('save-shortcodes').addEventListener('click', function() {
            const shortcodes = [];
            document.querySelectorAll('.shortcode-item').forEach((item) => {
                const name = item.querySelector('.shortcode-name').value.trim();
                const html = item.querySelector('.html-input').value;
                if (name && html) {
                    shortcodes.push({ name, html });
                }
            });

            jQuery.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'save_shortcodes',
                    nonce: '<?php echo wp_create_nonce("dwsd_nonce"); ?>',
                    shortcodes: shortcodes
                },
                success: function(response) {
                    alert(response.success ? 'Shortcodes zijn opgeslagen!' : 'Fout bij opslaan.');
                }
            });
        });
    </script>
    <?php
}

add_action('init', 'dwsd_register_shortcodes');

function dwsd_register_shortcodes() {
    $shortcodes = get_option('dwsd_shortcodes', []);
    foreach ($shortcodes as $data) {
        if (!empty($data['name']) && !empty($data['html'])) {
            add_shortcode($data['name'], function() use ($data) {
                return $data['html'];
            });
        }
    }
}

add_action('wp_ajax_save_shortcodes', 'dwsd_save_shortcodes');

function dwsd_save_shortcodes() {
    check_ajax_referer('dwsd_nonce', 'nonce');

    $shortcodes = $_POST['shortcodes'];
    if (is_array($shortcodes)) {
        foreach ($shortcodes as &$shortcode) {
            $shortcode['html'] = wp_kses_post($shortcode['html']);
            $shortcode['name'] = sanitize_title($shortcode['name']);
        }
        update_option('dwsd_shortcodes', $shortcodes);
        wp_send_json_success();
    } else {
        wp_send_json_error('Ongeldige gegevens');
    }
}
