<?php
/**
 * Plugin Name: De Web Developer: Tag Manager
 * Description: Voeg eenvoudig scripts en code toe aan de header en footer van uw website.
 * Version: 2.0
 * Author: DWSD Groep Amsterdam
 * Author URI: https://dwsdgroep.nl
 * License: GPL2
 */

// Voorkom directe toegang
if (!defined('ABSPATH')) {
    exit;
}

// Menu optie toevoegen aan het dashboard
add_action('admin_menu', 'smrtcp_add_admin_menu');

function smrtcp_add_admin_menu() {
    add_menu_page(
        'Tag Manager',
        'Tag Manager',
        'manage_options',
        'smrtcp_options',
        'smrtcp_options_page',
        plugin_dir_url(__FILE__) . 'assets/images/favicon-small-logo.svg', // URL van het icoon
        4 // Optionele parameter voor de positie van het menu-item
    );
}

// Functie om de opties pagina weer te geven
function smrtcp_options_page() {
    ?>
    <div id="popup" class="popup">
      <h2>⚠️ Opgelet!</h2>
      <p>U staat op het punt om de ontwikkelomgeving van De Web Developerervice te betreden. Wijzigingen die op deze pagina worden aangebracht, kunnen effect hebben op de gehele website! Het bewerken gebeurt volledig op eigen risico!</p>
      <button onclick="closePopup()">Ja, ik heb het begrepen</button> <button onclick="window.location.href = '<?php echo admin_url(); ?>'">Nee, keer terug naar dashboard</button>
    </div>

    <div id="overlay" class="overlay"></div>

    <script>
    window.onload = function() {
      openPopup();
    };

    function openPopup() {
      document.getElementById("popup").style.display = "block";
      document.getElementById("overlay").style.display = "block";
    }

    function closePopup() {
      document.getElementById("popup").style.display = "none";
      document.getElementById("overlay").style.display = "none";
    }
    </script>

    <div class="wrap smartcomputers-applicatie">
      <div class="wrapper-smarter-inner-content-left">
        <h1><img src="<?php echo plugins_url(''); ?>" alt=""> De Web Developer Tag Manager Plugin</h1>
        <p>
        De De Web Developer Tag Manager plugin van De Web Developer biedt een eenvoudige manier om aangepaste scripts toe te voegen aan uw WordPress-site, specifiek tussen de header, body en footer tags. Deze krachtige tool is ontworpen voor webontwikkelaars en beheerders die de functionaliteit en het ontwerp van hun website willen aanpassen zonder de onderliggende thema- of pluginbestanden handmatig te hoeven bewerken.</p>

        <h2>Snel en efficiënt</h2>
        <p>Met De Web Developer Tag Manager kunt uw snel en efficiënt JavaScript, CSS of HTML snippets invoegen op strategische plaatsen binnen uw website. Dit kan bijvoorbeeld handig zijn voor het toevoegen van trackingcodes, aangepaste styling of andere scripts die specifieke functionaliteit vereisen.</p>

        <h2>Let op met wijzigingen</h2>
        <p>Wij raden gebruikers ten zeerste aan om geen wijzigingen of toevoegingen te doen in de ingestelde scripts tenzij zij volledig begrijpen wat de consequenties hiervan kunnen zijn. Onjuiste of ongepaste scripts kunnen leiden tot ernstige problemen, zoals het breken van de site-layout, het veroorzaken van fouten of zelfs het volledig offline halen van de website. Alle aanpassingen en toevoegingen worden op eigen risico uitgevoerd.</p>

        <h2>Support</h2>
        <p>Mocht uw twijfelen over een wijziging, neem dan contact op met de deskundige ondersteuning van De Web Developer via <a href="mailto:support@dwsdgroep.nl">support@dwsdgroep.nl</a>. Onze specialisten staan klaar om u te helpen en te zorgen dat uw website optimaal blijft functioneren.</p>

        <h2>Eenvoudige interface</h2>
        <p>De De Web Developer Tag Manager plugin zorgt voor een moeiteloze integratie en biedt een gebruiksvriendelijke interface die zelfs voor beginners gemakkelijk te navigeren is. Echter, vanwege de krachtige aard van de plugin, raden wij altijd aan om een back-up van uw site te maken voordat u wijzigingen doorvoert.</p>
      </div>

      <div class="wrapper-smarter-inner-content-right">

        <?php
        // URL van de externe repository pagina
        $url = 'https://repository.dwsdgroep.nl/dwsd-repository.php';

        // Haal de inhoud op via wp_remote_get
        $response = wp_remote_get($url);

        // Controleer of er geen fout is bij het ophalen van de inhoud
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            echo '<p>Er is een fout opgetreden: ' . esc_html($error_message) . '</p>';
        } else {
            // Verkrijg de HTML inhoud van de externe pagina
            $body = wp_remote_retrieve_body($response);

            // Toon de inhoud
            echo $body;
        }
        ?>
        
      </div>

        <form method="post" action="options.php">
            <?php
            settings_fields('smrtcp_settings_group');
            do_settings_sections('smrtcp_options');
            submit_button('Opslaan instellingen');
            ?>
        </form>
    </div>
    <?php
}

// Register instellingen
add_action('admin_init', 'smrtcp_settings_init');

function smrtcp_settings_init() {
    register_setting('smrtcp_settings_group', 'smrtcp_head_code');
    register_setting('smrtcp_settings_group', 'smrtcp_after_body_code');
    register_setting('smrtcp_settings_group', 'smrtcp_footer_code');
    register_setting('smrtcp_settings_group', 'smrtcp_css_editor', 'smrtcp_save_css_to_file'); // Registratie van CSS-editor instelling met callback

    add_settings_section('smrtcp_section', '', null, 'smrtcp_options');
    add_settings_field('smrtcp_css_editor', 'CSS Editor <span id="uitleg">De editor hiernaast staat in verbinding met het CSS bestand dat genesteld is op de locatie: <span class="css-uitleg-pad">/wp-content/plugins/dewebdeveloper-tag-manager/css/front-end.css</span> Het is niet mogelijk het CSS bestand op deze locatie te bewerken, omdat er geen omgekeerde synchronisatie plaats vind.</span>', 'smrtcp_css_editor_render', 'smrtcp_options', 'smrtcp_section');
    add_settings_field('smrtcp_head_code', 'Voeg snippets toe tussen <b>&lt;head&gt;</b> tag', 'smrtcp_head_code_render', 'smrtcp_options', 'smrtcp_section');
    add_settings_field('smrtcp_after_body_code', 'Voeg snippets toe na <b>&lt;body&gt;</b> openings tag', 'smrtcp_after_body_code_render', 'smrtcp_options', 'smrtcp_section');
    add_settings_field('smrtcp_footer_code', 'Voeg snippets toe na <b>&lt;footer&gt;</b> openings tag', 'smrtcp_footer_code_render', 'smrtcp_options', 'smrtcp_section'); // Veld voor CSS Editor
}

// Callback functies voor het renderen van velden
function smrtcp_head_code_render() {
    $head_code = get_option('smrtcp_head_code');
    ?>
    <textarea id="smrtcp_head_code" name="smrtcp_head_code" rows="5" cols="50"><?php echo esc_textarea($head_code); ?></textarea>
    <?php
}

function smrtcp_after_body_code_render() {
    $after_body_code = get_option('smrtcp_after_body_code');
    ?>
    <textarea id="smrtcp_after_body_code" name="smrtcp_after_body_code" rows="5" cols="50"><?php echo esc_textarea($after_body_code); ?></textarea>
    <?php
}

function smrtcp_footer_code_render() {
    $footer_code = get_option('smrtcp_footer_code');
    ?>
    <textarea id="smrtcp_footer_code" name="smrtcp_footer_code" rows="5" cols="50"><?php echo esc_textarea($footer_code); ?></textarea>
    <?php
}

function smrtcp_css_editor_render() {
    $css_editor = get_option('smrtcp_css_editor');
    ?>
    <textarea id="smrtcp_css_editor" name="smrtcp_css_editor" rows="10" cols="50"><?php echo esc_textarea($css_editor); ?></textarea>
    <?php
}

// Hooks voor het injecteren van code in de header, body en footer
add_action('wp_head', 'smrtcp_inject_head_code');
add_action('wp_body_open', 'smrtcp_inject_after_body_code');
add_action('wp_footer', 'smrtcp_inject_footer_code');

// Callback functies voor het injecteren van code
function smrtcp_inject_head_code() {
    echo get_option('smrtcp_head_code');
}

function smrtcp_inject_after_body_code() {
    echo get_option('smrtcp_after_body_code');
}

function smrtcp_inject_footer_code() {
    echo get_option('smrtcp_footer_code');
}

// Admin assets en scripts en stijlen
add_action('admin_enqueue_scripts', 'smrtcp_enqueue_admin_assets');

function smrtcp_enqueue_admin_assets() {
    // Plugin stylesheet voor de admin
    wp_enqueue_style('smrtcp_admin_css', plugin_dir_url(__FILE__) . 'css/admin.css');
    wp_enqueue_style('smrtcp_custom_admin_css', plugin_dir_url(__FILE__) . 'css/style.css'); // Voeg deze regel toe voor de aangepaste admin-stijl

    // CodeMirror stylesheets en scripts
    wp_enqueue_style('codemirror-css', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/codemirror.min.css');
    wp_enqueue_style('codemirror-theme', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/theme/dracula.min.css');
    wp_enqueue_script('codemirror-js', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/codemirror.min.js', array(), null, true);
    wp_enqueue_script('codemirror-mode-js', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/mode/javascript/javascript.min.js', array('codemirror-js'), null, true);
    wp_enqueue_script('codemirror-mode-css', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/mode/css/css.min.js', array('codemirror-js'), null, true);
    wp_enqueue_script('codemirror-mode-html', 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/mode/htmlmixed/htmlmixed.min.js', array('codemirror-js'), null, true);

    // Aangepast script om CodeMirror te initialiseren
    wp_enqueue_script('smrtcp-codemirror-init', plugin_dir_url(__FILE__) . 'js/codemirror-init.js', array('codemirror-js', 'codemirror-mode-js', 'codemirror-mode-css', 'codemirror-mode-html'), null, true);
}

// Functie om CSS op te slaan in een bestand
function smrtcp_save_css_to_file($css) {
    $css_file = plugin_dir_path(__FILE__) . 'css/front-end.css';
    file_put_contents($css_file, $css);
    return $css;
}

// Functie om de CSS toe te voegen aan de front-end
function smrtcp_enqueue_front_end_css() {
    if (!is_admin()) {
        $css_file_url = plugin_dir_url(__FILE__) . 'css/front-end.css';
        wp_enqueue_style('smrtcp_custom_css', $css_file_url);
    }
}

// Hook om de CSS in te voegen in de wp_enqueue_scripts hook
add_action('wp_enqueue_scripts', 'smrtcp_enqueue_front_end_css');
?>
