<?php
/**
 * Plugin Name: De Web Developer: Verberg heading
 * Description: Verbergt de paginatitel in het Storefront-thema met een eenvoudig vinkje. Deze is in te stellen per pagina. Hiermee voorkom je dubbele <h1> tags.
 * Version: 1.0.2
 * Author: DWSD Groep Amsterdam
 * Author URI: https://dwsdgroep.nl
 */

if (!defined('ABSPATH')) exit; // Voorkomt directe toegang

// Voeg een metabox toe aan pagina's en berichten
function dwsd_add_meta_box() {
    add_meta_box(
        'dwsd_hide_title',
        __('Verberg paginatitel', 'storefront-title-hide'),
        'dwsd_meta_box_callback',
        ['page', 'post'],
        'side',
        'high'
    );
}
add_action('add_meta_boxes', 'dwsd_add_meta_box');

// Render de metabox
function dwsd_meta_box_callback($post) {
    wp_nonce_field('dwsd_hide_title_nonce', 'dwsd_hide_title_nonce');
    $value = get_post_meta($post->ID, '_dwsd_hide_title', true);
    ?>
    <p>
        <input type="checkbox" id="dwsd_hide_title" name="dwsd_hide_title" value="1" <?php checked($value, '1'); ?>>
        <label for="dwsd_hide_title"><?php _e('Verberg titel', 'storefront-title-hide'); ?></label>
    </p>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let metaBoxHeader = document.querySelector("#dwsd_hide_title .hndle");
            if (metaBoxHeader) {
                let logo = document.createElement("img");
                logo.src = "/wp-content/themes/dewebdeveloper/assets/images/favicon-small-logo.svg";
                logo.alt = "Logo";
                logo.style.width = "20px";
                logo.style.height = "20px";
                logo.style.verticalAlign = "middle";
                logo.style.marginRight = "5px";

                metaBoxHeader.prepend(logo);
            }
        });
    </script>
    <?php
}

// Opslaan van de metabox-instellingen
function dwsd_save_meta_box($post_id) {
    if (!isset($_POST['dwsd_hide_title_nonce']) || !wp_verify_nonce($_POST['dwsd_hide_title_nonce'], 'dwsd_hide_title_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (isset($_POST['dwsd_hide_title'])) {
        update_post_meta($post_id, '_dwsd_hide_title', '1');
    } else {
        delete_post_meta($post_id, '_dwsd_hide_title');
    }
}
add_action('save_post', 'dwsd_save_meta_box');

// Titel verbergen op de frontend
function dwsd_hide_title($title, $id = null) {
    if (is_singular() && in_the_loop() && !is_admin()) {
        if (!$id) {
            global $post;
            $id = $post->ID;
        }

        $hide_title = get_post_meta($id, '_dwsd_hide_title', true);
        if ($hide_title == '1') {
            return '';
        }
    }
    return $title;
}
add_filter('the_title', 'dwsd_hide_title', 10, 2);

add_filter('the_title', 'dwsd_hide_title', 10, 2);
